// ============================================================================
//
// This file are where the Conditions/Actions/Expressions are defined.
// You can manually enter these, or use CICK (recommended)
// See the Extension FAQ in this SDK for more info and where to download it
//
// ============================================================================

#define MAIN_CPP

// Common Include
#include	"common.h"
#include    "ImageFlt.h" 
#include    "ImgFlt.h" 
#include    "CfcFile.h" 
// Prototype of added procedures
void ResizeObject(mv _far *knpV, LPEDATA edPtr, int w, int h);
POINT * GeneratePointList(LPRDATA rdPtr, char * Str, long & NumPoints);
void FastSortPoints(POINT * Points, long NumPoints);
bool SortPoints(POINT * Points, long NumPoints, POINT * Original, long OrgPoints);
bool TestPoints(POINT * Points, long NumPoints);
bool SegmentsIntersect(POINT P11, POINT P12, POINT P21, POINT P22);
void StretchObject(LPRDATA rdPtr);

BOOL LoadImageFile(LPRDATA rdPtr, LPSURFACE psf, LPSTR pFileName, DWORD dwFlags = IMPORT_IMAGE_USESURFACEDEPTH | IMPORT_IMAGE_USESURFACEPALETTE); 
extern BlitOp EffectCodes[];


// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]

// Definitions of parameters for each condition
short conditionsInfos[]=
{
	IDMN_CND_MATCH,    M_CND_MATCH,    CND_MATCH,    EVFLAGS_ALWAYS+EVFLAGS_NOTABLE, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_COLOUR, M_ENTER_X, M_ENTER_Y, 0,
		IDMN_CND_MATCHRGB, M_CND_MATCHRGB, CND_MATCHRGB, EVFLAGS_ALWAYS+EVFLAGS_NOTABLE, 5, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_CND_OUTSIDE,  M_CND_OUTSIDE,  CND_OUTSIDE,  EVFLAGS_ALWAYS+EVFLAGS_NOTABLE, 2, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y,
		IDMN_CND_DEBUGON,  M_CND_DEBUGON,  CND_DEBUGON,  EVFLAGS_ALWAYS+EVFLAGS_NOTABLE, 0,
		IDMN_CND_RANGERGB, M_CND_RANGERGB, CND_RANGERGB, EVFLAGS_ALWAYS+EVFLAGS_NOTABLE, 5,
		PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION,
		PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_CND_FADE_DONE,M_CND_FADE_DONE,CND_FADE_DONE, 0, 0,
		IDMN_CND_FADING,   M_CND_FADING,   CND_FADING,   EVFLAGS_ALWAYS+EVFLAGS_NOTABLE, 0,

};

// Definitions of parameters for each action
short actionsInfos[]=
{
	IDMN_ACT_DEBUGON,  M_ACT_DEBUGON,  ACT_DEBUGON,  0, 0,
		IDMN_ACT_DEBUGOFF, M_ACT_DEBUGOFF, ACT_DEBUGOFF, 0, 0,
		IDMN_ACT_CLEAR,     M_ACT_CLEAR,     ACT_CLEAR,     0, 1, PARAM_COLOUR, 0,
		IDMN_ACT_REPLACE,   M_ACT_REPLACE,   ACT_REPLACE,   0, 2, PARAM_COLOUR, PARAM_COLOUR, 0, 0,
		IDMN_ACT_PIXEL,     M_ACT_PIXEL,     ACT_PIXEL,     0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_COLOUR, M_ENTER_X, M_ENTER_Y, 0,
		IDMN_ACT_LINE,      M_ACT_LINE,      ACT_LINE,      0, 5, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_COLOUR, M_ENTER_X1, M_ENTER_Y1, M_ENTER_X2, M_ENTER_Y2, 0,
		IDMN_ACT_RECTANGLE, M_ACT_RECTANGLE, ACT_RECTANGLE, 0, 5, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_COLOUR, M_ENTER_X, M_ENTER_Y, M_ENTER_W, M_ENTER_H, 0,
		IDMN_ACT_CIRCLE,    M_ACT_CIRCLE,    ACT_CIRCLE,    0, 5, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_COLOUR, M_ENTER_CX, M_ENTER_CY, M_ENTER_W, M_ENTER_H, 0,
		IDMN_ACT_CLEARRGB,     M_ACT_CLEARRGB,     ACT_CLEARRGB,     0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_REPLACERGB,   M_ACT_REPLACERGB,   ACT_REPLACERGB,   0, 6, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_R, M_ENTER_G, M_ENTER_B, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_PIXELRGB,     M_ACT_PIXELRGB,     ACT_PIXELRGB,     0, 5, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_LINERGB,      M_ACT_LINERGB,      ACT_LINERGB,      0, 7, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X1, M_ENTER_Y1, M_ENTER_X2, M_ENTER_Y2, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_RECTANGLERGB, M_ACT_RECTANGLERGB, ACT_RECTANGLERGB, 0, 7, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_W, M_ENTER_H, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_CIRCLERGB,    M_ACT_CIRCLERGB,    ACT_CIRCLERGB,    0, 7, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_CX, M_ENTER_CY, M_ENTER_W, M_ENTER_H, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_LOADBMP, M_ACT_LOADBMP, ACT_LOADBMP, 0, 1, PARAM_FILENAME, M_ENTER_FILENAME,
		IDMN_ACT_STRETCHON,	 M_ACT_STRETCHON,  ACT_STRETCHON,  0, 0,
		IDMN_ACT_STRETCHOFF, M_ACT_STRETCHOFF, ACT_STRETCHOFF, 0, 0,
		IDMN_ACT_FILL,     M_ACT_FILL,     ACT_FILL,     0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_COLOUR, M_ENTER_X, M_ENTER_Y, 0,
		IDMN_ACT_FILLRGB,     M_ACT_FILLRGB,     ACT_FILLRGB,     0, 5, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_R, M_ENTER_G, M_ENTER_B,
		IDMN_ACT_SAVEBMP, M_ACT_SAVEBMP, ACT_SAVEBMP, 0, 1, PARAM_FILENAME, M_ENTER_FILENAME,
		IDMN_ACT_SET_POS, M_ACT_SET_POS, ACT_SET_POS, 0, 1, PARAM_POSITION, M_ENTER_POS,
		IDMN_ACT_SET_XPOS, M_ACT_SET_XPOS, ACT_SET_XPOS, 0, 1, PARAM_EXPRESSION, M_ENTER_X,
		IDMN_ACT_SET_YPOS, M_ACT_SET_YPOS, ACT_SET_YPOS, 0, 1, PARAM_EXPRESSION, M_ENTER_Y,
		IDMN_ACT_AUTOON,  M_ACT_AUTOON,  ACT_AUTOON,  0, 0,
		IDMN_ACT_AUTOOFF, M_ACT_AUTOOFF, ACT_AUTOOFF, 0, 0,
		IDMN_ACT_IMMEDIATEON,  M_ACT_IMMEDIATEON,  ACT_IMMEDIATEON,  0, 0,
		IDMN_ACT_IMMEDIATEOFF, M_ACT_IMMEDIATEOFF, ACT_IMMEDIATEOFF, 0, 0,
		IDMN_ACT_ABSOLUTEON,  M_ACT_ABSOLUTEON,  ACT_ABSOLUTEON,  0, 0,
		IDMN_ACT_ABSOLUTEOFF, M_ACT_ABSOLUTEOFF, ACT_ABSOLUTEOFF, 0, 0,
		IDMN_ACT_MODEOPAQUE, M_ACT_MODEOPAQUE, ACT_MODEOPAQUE, 0, 0,
		IDMN_ACT_MODETRANSP, M_ACT_MODETRANSP, ACT_MODETRANSP, 0, 0,
		IDMN_ACT_UPDATE, M_ACT_UPDATE, ACT_UPDATE, 0, 0,
		IDMN_ACT_CLEARNEW,     M_ACT_CLEARNEW,     ACT_CLEARNEW,     0, 1, PARAM_EXPRESSION, M_ENTER_INDEX,
		IDMN_ACT_REPLACENEW,   M_ACT_REPLACENEW,   ACT_REPLACENEW,   0, 2, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_INDEX, M_ENTER_INDEX,
		IDMN_ACT_PIXELNEW,     M_ACT_PIXELNEW,     ACT_PIXELNEW,     0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_INDEX,
		IDMN_ACT_LINENEW,      M_ACT_LINENEW,      ACT_LINENEW,      0, 6, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X1, M_ENTER_Y1, M_ENTER_X2, M_ENTER_Y2, M_ENTER_THICK, M_ENTER_INDEX,
		IDMN_ACT_RECTANGLENEW, M_ACT_RECTANGLENEW, ACT_RECTANGLENEW, 0, 7, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_W, M_ENTER_H, M_ENTER_FCOL, M_ENTER_THICK, M_ENTER_OCOL,
		IDMN_ACT_CIRCLENEW,    M_ACT_CIRCLENEW,    ACT_CIRCLENEW,    0, 7, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_CX, M_ENTER_CY, M_ENTER_W, M_ENTER_H, M_ENTER_FCOL, M_ENTER_THICK, M_ENTER_OCOL,
		IDMN_ACT_FILLNEW,      M_ACT_FILLNEW,      ACT_FILLNEW,      0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y, M_ENTER_INDEX,
		IDMN_ACT_POLYGON,      M_ACT_POLYGON,      ACT_POLYGON,      0, 4, PARAM_EXPSTRING, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_POINTS, M_ENTER_FCOL, M_ENTER_THICK, M_ENTER_OCOL,
		IDMN_ACT_RESIZE, M_ACT_RESIZE, ACT_RESIZE, 0, 2, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_W, M_ENTER_H,
		IDMN_ACT_ADDPOINT, M_ACT_ADDPOINT, ACT_ADDPOINT, 0, 2, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_X, M_ENTER_Y,
		IDMN_ACT_PLOTPOLY, M_ACT_PLOTPOLY, ACT_PLOTPOLY, 0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_FCOL, M_ENTER_THICK, M_ENTER_OCOL,
		IDMN_ACT_CLEARPTS, M_ACT_CLEARPTS, ACT_CLEARPTS, 0, 0,
		IDMN_ACT_PASTEOBJ, M_ACT_PASTEOBJ, ACT_PASTEOBJ, 0, 1, PARAM_OBJECT, M_ENTER_OBJECT,
		IDMN_ACT_KEEPPTSON,  M_ACT_KEEPPTSON,  ACT_KEEPPTSON,  0, 0,
		IDMN_ACT_KEEPPTSOFF, M_ACT_KEEPPTSOFF, ACT_KEEPPTSOFF, 0, 0,
		IDMN_ACT_INK_NONE, M_ACT_INK_NONE, ACT_INK_NONE, 0, 0,
		IDMN_ACT_INK_SEMI, M_ACT_INK_SEMI, ACT_INK_SEMI, 0, 1, PARAM_EXPRESSION, M_ENTER_INK,
		IDMN_ACT_INK_INVERT, M_ACT_INK_INVERT, ACT_INK_INVERT, 0, 0,
		IDMN_ACT_INK_XOR, M_ACT_INK_XOR, ACT_INK_XOR, 0, 0,
		IDMN_ACT_INK_AND, M_ACT_INK_AND, ACT_INK_AND, 0, 0,
		IDMN_ACT_INK_OR, M_ACT_INK_OR, ACT_INK_OR, 0, 0,
		IDMN_ACT_INK_ANDNOT, M_ACT_INK_ANDNOT, ACT_INK_ANDNOT, 0, 0,
		IDMN_ACT_ANTIAON,  M_ACT_ANTIAON,  ACT_ANTIAON,  0, 0,
		IDMN_ACT_ANTIAOFF, M_ACT_ANTIAOFF, ACT_ANTIAOFF, 0, 0,
		IDMN_ACT_SETINK, M_ACT_SETINK, ACT_SETINK, 0, 1, PARAM_EXPRESSION, M_ENTER_INK,
		IDMN_ACT_AUTOINK, M_ACT_AUTOINK, ACT_AUTOINK, 0, 1, PARAM_EXPRESSION, M_ENTER_INKSPEED,
		IDMN_ACT_STOPINK, M_ACT_STOPINK, ACT_STOPINK, 0, 0,
		IDMN_ACT_REVINK, M_ACT_REVINK, ACT_REVINK, 0, 0,
		IDMN_ACT_SETEFFECT, M_ACT_SETEFFECT, ACT_SETEFFECT, 0, 1, PARAM_EXPRESSION,M_ENTER_EFFECT,
		IDMN_ACT_SHAPE,     M_ACT_SHAPE,     ACT_SHAPE,     0, 4, PARAM_EXPSTRING, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_POINTS, M_ENTER_FCOL, M_ENTER_THICK, M_ENTER_OCOL,
		IDMN_ACT_PLOTSHAPE, M_ACT_PLOTSHAPE, ACT_PLOTSHAPE, 0, 3, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, M_ENTER_FCOL, M_ENTER_THICK, M_ENTER_OCOL,
		IDMN_ACT_PASTEOVERLAY, M_ACT_PASTEOVERLAY, ACT_PASTEOVERLAY, 0, 9, PARAM_EXPRESSION,PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION,PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION, PARAM_EXPRESSION,M_ENT_FIXED, M_ENT_SOURCEX, M_ENT_SOURCEY, M_ENT_SOURCEW, M_ENT_SOURCEH,M_ENT_DESTX, M_ENT_DESTY, M_ENT_DESTW, M_ENT_DESTH,
		IDMN_ACT_DRAWSTRING,M_ACT_DRAWSTRING,ACT_DRAWSTRING,0,8,PARAM_EXPSTRING,PARAM_EXPRESSION,PARAM_EXPRESSION,PARAM_EXPRESSION,PARAM_EXPRESSION,PARAM_EXPSTRING,PARAM_EXPRESSION,PARAM_EXPRESSION,M_DS_TEXT,M_DS_X,M_DS_Y,M_DS_W,M_DS_H,M_DS_FF,M_DS_FS,M_DS_FC,
};

// Definitions of parameters for each expression
short expressionsInfos[]=
{
	IDMN_EXP_GETRED,   M_EXP_GETRED,   EXP_GETRED,   0, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,
		IDMN_EXP_GETGREEN, M_EXP_GETGREEN, EXP_GETGREEN, 0, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,
		IDMN_EXP_GETBLUE,  M_EXP_GETBLUE,  EXP_GETBLUE,  0, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,
		IDMN_EXP_GETCOLOR, M_EXP_GETCOLOR, EXP_GETCOLOR, EXPFLAG_STRING, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,
		IDMN_EXP_GETRGB,   M_EXP_GETRGB,   EXP_GETRGB,   EXPFLAG_STRING, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,
		IDMN_EXP_GETXPOS,  M_EXP_GETXPOS,  EXP_GETXPOS,  0, 0,
		IDMN_EXP_GETYPOS,  M_EXP_GETYPOS,  EXP_GETYPOS,  0, 0,
		IDMN_EXP_RANGE,    M_EXP_RANGE,	   EXP_RANGE,    0, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,
		IDMN_EXP_NOFILL,   M_EXP_NOFILL,   EXP_NOFILL,   0, 0,
		IDMN_EXP_GETWIDTH, M_EXP_GETWIDTH, EXP_GETWIDTH, 0, 0,
		IDMN_EXP_GETHEIGHT,M_EXP_GETHEIGHT,EXP_GETHEIGHT,0, 0,
		IDMN_EXP_GETINK,   M_EXP_GETINK,   EXP_GETINK,   0, 0,
		IDMN_EXP_GETINKSPEED,M_EXP_GETINKSPEED,EXP_GETINKSPEED,EXPFLAG_DOUBLE,0,
		IDMN_EXP_GETEFFECT,M_EXP_GETEFFECT,EXP_GETEFFECT,0, 0,
		IDMN_EXP_GETFIXED, M_EXP_GETFIXED, EXP_GETFIXED, 0, 0,
		IDMN_EXP_GETCINDEX,M_EXP_GETCINDEX,EXP_GETCINDEX,0, 2, EXPPARAM_LONG, EXPPARAM_LONG, 0, 0,

};


// ============================================================================
//
// CONDITION ROUTINES
// 
// ============================================================================

// -----------------
// Sample Condition
// -----------------
// Returns TRUE when the two values are equal!
// 
long WINAPI DLLExport cndMatchColor(LPRDATA rdPtr, long param1, long param2)
{

	COLORREF	colorRGB, cRGB;
	BYTE		colorRed, cRed;
	BYTE		colorGreen, cGreen;
	BYTE		colorBlue, cBlue;

	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pColor = CNC_GetParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->GetPixel(pX, pY, colorRGB);

	if (pColor != NULL)
	{
		cRGB = (COLORREF)pColor;

		cRed = GetRValue(cRGB)>=128?255:0;
		cGreen = GetGValue(cRGB)>=128?255:0;
		cBlue = GetBValue(cRGB)>=128?255:0;

		colorRed = GetRValue(colorRGB)>=128?255:0;
		colorGreen = GetGValue(colorRGB)>=128?255:0;
		colorBlue = GetBValue(colorRGB)>=128?255:0;

		if((colorRed == cRed) && (colorGreen == cGreen) && (colorBlue == cBlue))
			return TRUE;
		return FALSE;
	}
	return FALSE;
}

long WINAPI DLLExport cndMatchColorRGB(LPRDATA rdPtr, long param1, long param2)
{

	COLORREF	colorRGB;
	BYTE		colorRed, cRed;
	BYTE		colorGreen, cGreen;
	BYTE		colorBlue, cBlue;

	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->GetPixel(pX, pY, colorRGB);

	cRed = pR>=128?255:0;
	cGreen = pG>=128?255:0;
	cBlue = pB>=128?255:0;

	colorRed = GetRValue(colorRGB)>=128?255:0;
	colorGreen = GetGValue(colorRGB)>=128?255:0;
	colorBlue = GetBValue(colorRGB)>=128?255:0;

	if((colorRed == cRed) && (colorGreen == cGreen) && (colorBlue == cBlue))
		return TRUE;

	return FALSE;
}

long WINAPI DLLExport cndIsOutside(LPRDATA rdPtr, long param1, long param2)
{
	//adjust position (this condition only works with absolute positions)
	param1 -= rdPtr->X;
	param2 -= rdPtr->Y;

	if((param1 < 0) || (param2 < 0) || (param1 > rdPtr->swidth) || (param2 > rdPtr->sheight))
		return TRUE;

	return FALSE;
}

long WINAPI DLLExport cndIsDebugOn(LPRDATA rdPtr, long param1, long param2)
{
	return rdPtr->debugmode;
}

long WINAPI DLLExport cndCompareRGB(LPRDATA rdPtr, long param1, long param2)
{
	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	//we allow ranges here, so get those
	long RangeR = HIWORD(pR);
	long RangeG = HIWORD(pG);
	long RangeB = HIWORD(pB);
	//now, get the originals
	pR = LOWORD(pR);
	pG = LOWORD(pG);
	pB = LOWORD(pB);

	//adjust the colors sizes
	AdjCol(pR,pG,pB);

	//get color at point
	COLORREF colorRGB;
	rdPtr->runSurface->GetPixel(pX, pY, colorRGB);

	return (InRange((long)GetRValue(colorRGB),pR,pR+RangeR) 
		&& InRange((long)GetGValue(colorRGB),pG,pG+RangeG)
		&& InRange((long)GetBValue(colorRGB),pB,pB+RangeB));
}

long WINAPI DLLExport cndAlwaysTrue(LPRDATA rdPtr, long param1, long param2)
{
	return TRUE;
}

long WINAPI DLLExport cndIsFading(LPRDATA rdPtr, long param1, long param2)
{
	return rdPtr->Fade;
}

// ============================================================================
//
// ACTIONS ROUTINES
// 
// ============================================================================

//
// 
short CreateLine(LPRDATA rdPtr, int pX1, int pY1, int pX2, int pY2, COLORREF pColor)
{
	//	if((pX1 < 0) || (pY1 < 0) || (pX1 > rdPtr->swidth) || (pY1 > rdPtr->sheight))
	//		return FALSE;

	//	if((pX2 < 0) || (pY2 < 0) || (pX2 > rdPtr->swidth) || (pY2 > rdPtr->sheight))
	//		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->Line(pX1, pY1, pX2, pY2, 1, (COLORREF)pColor);

	return 0;
}

short CreateRectangle(LPRDATA rdPtr, int pLeft, int pTop, int pWidth, int pHeight, COLORREF pColor)
{
	//	if((pLeft < 0) || (pTop < 0) || ((pLeft + pWidth) > rdPtr->swidth) || ((pTop + pHeight) > rdPtr->sheight))
	//		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	long pRight = pLeft + pWidth;
	long pBottom = pTop + pHeight;

	rdPtr->runSurface->Rectangle(pLeft, pTop, pRight, pBottom, (COLORREF)pColor, 0, (COLORREF)pColor, TRUE);

	return 0;
}

short CreateEllipse(LPRDATA rdPtr, int pCX, int pCY, int pWidth, int pHeight, COLORREF pColor)
{

	long pLeft = pCX - (pWidth/2);
	long pTop = pCY - (pHeight/2);
	long pRight = pCX + (pWidth/2);
	long pBottom = pCY + (pHeight/2);

	//	if((pLeft < 0) || (pTop < 0) || (pRight > rdPtr->swidth) || (pBottom > rdPtr->sheight))
	//		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->Ellipse(pLeft, pTop, pRight, pBottom, (COLORREF)pColor, 1, (COLORREF)pColor, TRUE);

	return 0;
}

short WINAPI DLLExport actTurnDebugOn(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->debugmode = TRUE;
	UpDisp(rdPtr);
	return 0;
}

short WINAPI DLLExport actTurnDebugOff(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->debugmode = FALSE;
	UpDisp(rdPtr);
	return 0;
}

short WINAPI DLLExport actClearOverlay(LPRDATA rdPtr, long param1, long param2)
{

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->Fill((COLORREF)param1);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actFloodFill(LPRDATA rdPtr, long param1, long param2)
{
	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pColor = CNC_GetParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//Flood tool, kick out if point is out of range
	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->FloodFill(pX, pY, (COLORREF)pColor);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actReplaceColor(LPRDATA rdPtr, long param1, long param2)
{
	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->ReplaceColor((COLORREF)param2,(COLORREF)param1);

	UpDisp(rdPtr);

	return 0;
}


short WINAPI DLLExport actSetPixel(LPRDATA rdPtr, long param1, long param2)
{
	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pColor = CNC_GetParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//Just setting a pixel, kick out if need be
	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->SetPixel(pX, pY, (COLORREF)pColor);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawLine(LPRDATA rdPtr, long param1, long param2)
{
	long pX1 = CNC_GetIntParameter(rdPtr);
	long pY1 = CNC_GetIntParameter(rdPtr);
	long pX2 = CNC_GetIntParameter(rdPtr);
	long pY2 = CNC_GetIntParameter(rdPtr);
	long pColor = CNC_GetParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX1,pY1);
	AdjPos(rdPtr,pX2,pY2);

	CreateLine(rdPtr, pX1, pY1, pX2, pY2, pColor);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawRectangle(LPRDATA rdPtr, long param1, long param2)
{
	long pLeft = CNC_GetIntParameter(rdPtr);
	long pTop = CNC_GetIntParameter(rdPtr);
	long pWidth = CNC_GetIntParameter(rdPtr);
	long pHeight = CNC_GetIntParameter(rdPtr);
	long pColor = CNC_GetParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pLeft,pTop);

	CreateRectangle(rdPtr, pLeft, pTop, pWidth, pHeight, pColor);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawEllipse(LPRDATA rdPtr, long param1, long param2)
{
	long pCX = CNC_GetIntParameter(rdPtr);
	long pCY = CNC_GetIntParameter(rdPtr);
	long pWidth = CNC_GetIntParameter(rdPtr);
	long pHeight = CNC_GetIntParameter(rdPtr);
	long pColor = CNC_GetParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pCX,pCY);

	CreateEllipse(rdPtr, pCX, pCY, pWidth, pHeight, pColor);

	UpDisp(rdPtr);

	return 0;
}



short WINAPI DLLExport actClearOverlayRGB(LPRDATA rdPtr, long param1, long param2)
{
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//	if((pR < 0) || (pR > 255) || (pG < 0) || (pG > 255) || (pB < 0) || (pB > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR,pG,pB);

	COLORREF colorRGB = RGB((BYTE)pR,(BYTE)pG,(BYTE)pB);

	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->Fill(colorRGB);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actFloodFillRGB(LPRDATA rdPtr, long param1, long param2)
{
	COLORREF	colorRGB; 

	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//this is a flood fill, kick out if point is gone
	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	//	if((pR < 0) || (pR > 255) || (pG < 0) || (pG > 255) || (pB < 0) || (pB > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR,pG,pB);

	colorRGB = RGB((BYTE)pR,(BYTE)pG,(BYTE)pB);

	rdPtr->runSurface->FloodFill(pX, pY, colorRGB);

	UpDisp(rdPtr);	

	return 0;
}

short WINAPI DLLExport actReplaceColorRGB(LPRDATA rdPtr, long param1, long param2)
{
	long pR1 = CNC_GetIntParameter(rdPtr);
	long pG1 = CNC_GetIntParameter(rdPtr);
	long pB1 = CNC_GetIntParameter(rdPtr);

	long pR2 = CNC_GetIntParameter(rdPtr);
	long pG2 = CNC_GetIntParameter(rdPtr);
	long pB2 = CNC_GetIntParameter(rdPtr);

	//	if((pR1 < 0) || (pR1 > 255) || (pG1 < 0) || (pG1 > 255) || (pB1 < 0) || (pB1 > 255))
	//		return FALSE;

	//	if((pR2 < 0) || (pR2 > 255) || (pG2 < 0) || (pG2 > 255) || (pB2 < 0) || (pB2 > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR1,pG1,pB1);
	AdjCol(pR2,pG2,pB2);

	COLORREF colorOldRGB = RGB((BYTE)pR1,(BYTE)pG1,(BYTE)pB1);
	COLORREF colorNewRGB = RGB((BYTE)pR2,(BYTE)pG2,(BYTE)pB2);


	if(rdPtr->runSurface == NULL)
		return FALSE;

	rdPtr->runSurface->ReplaceColor(colorNewRGB,colorOldRGB);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actSetPixelRGB(LPRDATA rdPtr, long param1, long param2)
{
	COLORREF	colorRGB; 

	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//setting a pixel, kick out if need be
	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	//	if((pR < 0) || (pR > 255) || (pG < 0) || (pG > 255) || (pB < 0) || (pB > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR,pG,pB);

	colorRGB = RGB((BYTE)pR,(BYTE)pG,(BYTE)pB);

	//rdPtr->runSurface->SetPixel(pX, pY, colorRGB);
	rdPtr->runSurface->SetPixelFast(pX,pY,colorRGB);
	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawLineRGB(LPRDATA rdPtr, long param1, long param2)
{
	long pX1 = CNC_GetIntParameter(rdPtr);
	long pY1 = CNC_GetIntParameter(rdPtr);
	long pX2 = CNC_GetIntParameter(rdPtr);
	long pY2 = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX1,pY1);
	AdjPos(rdPtr,pX2,pY2);

	//	if((pR < 0) || (pR > 255) || (pG < 0) || (pG > 255) || (pB < 0) || (pB > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR,pG,pB);

	COLORREF colorRGB = RGB((BYTE)pR,(BYTE)pG,(BYTE)pB);

	CreateLine(rdPtr, pX1, pY1, pX2, pY2, colorRGB);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawRectangleRGB(LPRDATA rdPtr, long param1, long param2)
{
	long pLeft = CNC_GetIntParameter(rdPtr);
	long pTop = CNC_GetIntParameter(rdPtr);
	long pWidth = CNC_GetIntParameter(rdPtr);
	long pHeight = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pLeft,pTop);

	//	if((pR < 0) || (pR > 255) || (pG < 0) || (pG > 255) || (pB < 0) || (pB > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR,pG,pB);

	COLORREF colorRGB = RGB((BYTE)pR,(BYTE)pG,(BYTE)pB);

	CreateRectangle(rdPtr, pLeft, pTop, pWidth, pHeight, colorRGB);

	UpDisp(rdPtr);

	return 0;
}


short WINAPI DLLExport actDrawEllipseRGB(LPRDATA rdPtr, long param1, long param2)
{
	long pCX = CNC_GetIntParameter(rdPtr);
	long pCY = CNC_GetIntParameter(rdPtr);
	long pWidth = CNC_GetIntParameter(rdPtr);
	long pHeight = CNC_GetIntParameter(rdPtr);
	long pR = CNC_GetIntParameter(rdPtr);
	long pG = CNC_GetIntParameter(rdPtr);
	long pB = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pCX,pCY);

	//	if((pR < 0) || (pR > 255) || (pG < 0) || (pG > 255) || (pB < 0) || (pB > 255))
	//		return FALSE;

	//adjust colors
	AdjCol(pR,pG,pB);

	COLORREF colorRGB = RGB((BYTE)pR,(BYTE)pG,(BYTE)pB);

	CreateEllipse(rdPtr, pCX, pCY, pWidth, pHeight, colorRGB);

	UpDisp(rdPtr);

	return 0;
}
// Load image from file 
BOOL LoadImageFile(LPRDATA rdPtr, LPSURFACE psf, LPSTR pFileName, DWORD dwFlags) 
{ 
	BOOL    bOK = FALSE; 
	LPRH    rhPtr = rdPtr->rHo.hoAdRunHeader; 
	HANDLE    hf = INVALID_HANDLE_VALUE; 

	do { 
		if ( pFileName == NULL || *pFileName == 0 ) 
			break; 

		// Copy filename to temporary string 
		char fname[MAX_PATH]; 
		strcpy(fname, pFileName); 

		// Open file 
		// 
		// mvOpenHFile opens the file directly from the CCN/EXE file ifthe file has been included in the embedded binary files of the application. 
		// If the file is not embedded, mvOpenHFile opens it from its current location (and downloads it first in Vitalize mode). 
		// 
		DWORD dwSize;                                    // file size 
		hf = rhPtr->rh4.rh4Mv->mvOpenHFile(fname, &dwSize, 0); 
		if ( hf == INVALID_HANDLE_VALUE ) 
			break; 

		// Create CInputFile 
		DWORD dwOff = File_GetPosition((HFILE)hf);        // position of embedded file in CCN/EXE file (0 if not embedded) 
		CInputBufFile bf; 
		if ( bf.Create((HFILE)hf, dwOff, dwSize) != 0 ) 
			break; 

		// Load picture 
		if ( ImportImageFromInputFile(rhPtr->rh4.rh4Mv->mvImgFilterMgr, &bf, psf, NULL, dwFlags) ) 
			bOK = TRUE; 

	} while(FALSE); 

	if ( hf != INVALID_HANDLE_VALUE ) 
		rhPtr->rh4.rh4Mv->mvCloseHFile(hf); 

	return bOK; 
} 


short WINAPI DLLExport actLoadImage(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));
	cSurface * workSurface = new cSurface;
	workSurface->Clone(*rdPtr->runSurface,1,1);
	if(LoadImageFile(rdPtr,workSurface,p1))
	{
		//rdPtr->rFilename=p1;
		rdPtr->oldwidth = workSurface->GetWidth();
		rdPtr->oldheight = workSurface->GetHeight();

		if(rdPtr->stretching)
		{
			//stretch image
			workSurface->Stretch(*rdPtr->runSurface,STRF_COPYALPHA);
			workSurface->Delete();
			delete workSurface;
		}
		else
		{
			//resize overlay to fit image
			rdPtr->swidth = rdPtr->oldwidth;
			rdPtr->sheight = rdPtr->oldheight;
			rdPtr->runSurface->Delete();
			delete rdPtr->runSurface;
			rdPtr->runSurface = workSurface;
		}				

		//update display
		UpDisp(rdPtr);
	}
	else
	{
		workSurface->Delete();
		delete workSurface;
	}

	return 0;
}
DWORD FindFilter(LPRDATA rdPtr,CImageFilterMgr *pImgMgr,LPCSTR filepath)
{
	std::string FileStr=filepath;
	std::string::size_type findex = std::string::npos;
	int index=-1;
	int bmpindex=0;
	findex=FileStr.find_last_of('.')+1;
	for(int i=0;i<pImgMgr->GetFilterCount();i++)
	{
		if(pImgMgr->DoesFilterSupportImages(i))
		{
			LPCSTR*mFileExts=pImgMgr->GetFilterExts(i);
			LPCSTR ExtStr=NULL;
			ExtStr=(*mFileExts++);
			while(ExtStr!=NULL)
			{
				if(std::string(ExtStr)==std::string("bmp"))
					bmpindex=i;
				if(FileStr.substr(findex)==std::string(ExtStr))
				{
					index=i;
					break;
				}
				ExtStr=(*mFileExts++);
			}
			if(index!=-1)
				break;
		}
	}
	if(index==-1)
		index=bmpindex;
	MessageBox(NULL,pImgMgr->GetFilterName(index),"Test",NULL);
	return pImgMgr->GetFilterID(index);
}

short WINAPI DLLExport actSaveImage(LPRDATA rdPtr, long param1, long param2)
{
	fprh	rhPtr = rdPtr->rHo.hoAdRunHeader;
	CImageFilterMgr* pImgMgr = rhPtr->rh4.rh4Mv->mvImgFilterMgr;
	DWORD mFilter=NULL;
	//pImgMgr=pImgMgr->CreateInstance();
#if defined(VITALIZE)
	return 0;
#else
	if(rdPtr->runSurface!= NULL)
	{
		mFilter=FindFilter(rdPtr,pImgMgr,(LPCSTR)param1);

		if(!ExportImage(pImgMgr,(LPCSTR)param1,rdPtr->runSurface,mFilter))
		{
			LPSURFACE pProto = NULL;
			int depth=24;
			CImageFilter pFilter(pImgMgr);
			pFilter.UseSpecificFilterID(mFilter);

			if ( GetSurfacePrototype(&pProto, depth, ST_MEMORYWITHDC, SD_DIB) )
			{
				// OK
				cSurface * wNA = new cSurface();
				if (wNA!= NULL)
				{
					wNA->Create(rdPtr->swidth,rdPtr->sheight,pProto);
					rdPtr->runSurface->Blit(*wNA,0,0,BMODE_OPAQUE,BOP_COPY,0);
					ExportImage(pImgMgr,(LPCSTR)param1,wNA,mFilter);
					delete wNA;
				}

			}
		}
	}

	return 0;
#endif
}

short WINAPI DLLExport actTurnStretchingOn(LPRDATA rdPtr, long param1, long param2)
{


	//First get a prototype
	//clone a work surface from the runsurface
	//delete the runsurface
	//create a new runsurface from the prototype the size of the level.
	//stretch the work surface onto the new runsurface
	//delete the work surface.

	if(rdPtr->stretching || (rdPtr->runSurface == NULL))
		return 0;

	StretchObject(rdPtr);

	rdPtr->stretching = TRUE;
	UpDisp(rdPtr);
	return 0;

}

short WINAPI DLLExport actTurnStretchingOff(LPRDATA rdPtr, long param1, long param2)
{

	//First get a prototype
	//clone a work surface from the runsurface
	//delete the runsurface
	//create a new runsurface from the prototype the size of the level.
	//stretch the work surface onto the new runsurface
	//delete the work surface.
	if(!rdPtr->stretching || (rdPtr->runSurface == NULL))
		return 0;

	LPSURFACE workSurface = NULL;
	LPSURFACE pProto = NULL;

	workSurface = new cSurface;

	if ( GetSurfacePrototype(&pProto, rdPtr->runSurface->GetDepth(), ST_MEMORYWITHPERMANENTDC, SD_DIB) )
	{
		/*workSurface->Clone(*rdPtr->runSurface, rdPtr->runSurface->GetWidth(), rdPtr->runSurface->GetHeight());
		rdPtr->runSurface->Blit(*workSurface);
		rdPtr->runSurface->Delete();
		delete rdPtr->runSurface;*/
		workSurface = rdPtr->runSurface;

		rdPtr->runSurface = new cSurface;
		if (rdPtr->runSurface != NULL)
		{
			rdPtr->swidth = rdPtr->oldwidth;
			rdPtr->sheight = rdPtr->oldheight;
			rdPtr->X = rdPtr->OldX;
			rdPtr->Y = rdPtr->OldY;

			rdPtr->runSurface->Create(rdPtr->swidth,rdPtr->sheight,pProto);
			workSurface->Stretch(*rdPtr->runSurface,STRF_COPYALPHA);
		}
	}

	workSurface->Delete();
	delete workSurface;
	rdPtr->stretching = FALSE;
	UpDisp(rdPtr);
	return 0;
}

//set position
short WINAPI DLLExport actSetPosition(LPRDATA rdPtr, long Pos, long param2)
{
	short x = HIWORD(Pos),
		y = LOWORD(Pos);

	if(rdPtr->stretching)
	{
		//we cannot change the position while stretching is on!
		//  but record changes for when stretching is off
		rdPtr->OldX = x;
		rdPtr->OldY = y;
		return 0;
	}

	rdPtr->X = x;
	rdPtr->Y = y;
	rdPtr->rHo.hoX=rdPtr->X;
	rdPtr->rHo.hoY=rdPtr->Y;
	UpDisp(rdPtr);
	return 0;
}

//set X position
short WINAPI DLLExport actSetXPosition(LPRDATA rdPtr, long X, long param2)
{
	if(rdPtr->stretching)
	{
		//we cannot change the position while stretching is on!
		//  but record changes for when stretching is off
		rdPtr->OldX = X;
		return 0;
	}

	rdPtr->X = X;
	rdPtr->rHo.hoX=rdPtr->X;
	UpDisp(rdPtr);
	return 0;
}

//set Y position
short WINAPI DLLExport actSetYPosition(LPRDATA rdPtr, long Y, long param2)
{
	if(rdPtr->stretching)
	{
		//we cannot change the position while stretching is on!
		//  but record changes for when stretching is off
		rdPtr->OldY = Y;
		return 0;
	}

	rdPtr->Y = Y;
	rdPtr->rHo.hoY=rdPtr->Y;
	UpDisp(rdPtr);
	return 0;
}

//toggle settings!

short WINAPI DLLExport actAutoOn(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Automatic = TRUE;
	return 0;
}
short WINAPI DLLExport actAutoOff(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Automatic = FALSE;
	return 0;
}

short WINAPI DLLExport actImmediateOn(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Immediate = TRUE;
	return 0;
}
short WINAPI DLLExport actImmediateOff(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Immediate = FALSE;
	return 0;
}

short WINAPI DLLExport actAbsoluteOn(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->AbsolutePos = TRUE;
	return 0;
}
short WINAPI DLLExport actAbsoluteOff(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->AbsolutePos = FALSE;
	return 0;
}

short WINAPI DLLExport actModeOpaque(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Mode = BMODE_OPAQUE;
	return 0;
}
short WINAPI DLLExport actModeTransp(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Mode = BMODE_TRANSP;
	return 0;
}

//Update display
short WINAPI DLLExport actUpdateDisplay(LPRDATA rdPtr, long param1, long param2)
{
	callRunTimeFunction(rdPtr, RFUNCTION_REDISPLAY, 0, 0);	
	return 0;
}

//new drawing functions
short WINAPI DLLExport actClearOverlayNew(LPRDATA rdPtr, long Color, long param2)
{
	if(rdPtr->runSurface == NULL)
		return FALSE;

	AdjCol(Color);

	rdPtr->runSurface->Fill((COLORREF)Color);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actFloodFillNew(LPRDATA rdPtr, long param1, long param2)
{
	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long Color = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//Flood tool, kick out if point is out of range
	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	AdjCol(Color);

	rdPtr->runSurface->FloodFill(pX, pY, (COLORREF)Color);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actReplaceColorNew(LPRDATA rdPtr, long Color1, long Color2)
{
	if(rdPtr->runSurface == NULL)
		return FALSE;

	AdjCol(Color1);
	AdjCol(Color2);

	rdPtr->runSurface->ReplaceColor((COLORREF)Color2,(COLORREF)Color1);

	UpDisp(rdPtr);

	return 0;
}


short WINAPI DLLExport actSetPixelNew(LPRDATA rdPtr, long param1, long param2)
{
	long pX = CNC_GetIntParameter(rdPtr);
	long pY = CNC_GetIntParameter(rdPtr);
	long Color = CNC_GetIntParameter(rdPtr);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//Just setting a pixel, kick out if need be
	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return FALSE;

	if(rdPtr->runSurface == NULL)
		return FALSE;

	AdjCol(Color);

	rdPtr->runSurface->SetPixel(pX, pY, (COLORREF)Color);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawLineNew(LPRDATA rdPtr, long param1, long param2)
{
	long pX1 = CNC_GetIntParameter(rdPtr);
	long pY1 = CNC_GetIntParameter(rdPtr);
	long pX2 = CNC_GetIntParameter(rdPtr);
	long pY2 = CNC_GetIntParameter(rdPtr);
	long Thick = CNC_GetIntParameter(rdPtr);
	long Color = CNC_GetIntParameter(rdPtr);

	if(rdPtr->runSurface == NULL)
		return FALSE;

	//adjust position
	AdjPos(rdPtr,pX1,pY1);
	AdjPos(rdPtr,pX2,pY2);
	AdjCol(Color);
	AdjThick(Thick,1);

	rdPtr->runSurface->Line(pX1, pY1, pX2, pY2, Thick, (COLORREF)Color);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawRectangleNew(LPRDATA rdPtr, long param1, long param2)
{
	long pLeft = CNC_GetIntParameter(rdPtr);
	long pTop = CNC_GetIntParameter(rdPtr);
	long pWidth = CNC_GetIntParameter(rdPtr);
	long pHeight = CNC_GetIntParameter(rdPtr);
	long FColor = CNC_GetIntParameter(rdPtr);  //fill color (negative = no fill)
	long Thick = CNC_GetIntParameter(rdPtr);
	long OColor = CNC_GetIntParameter(rdPtr);  //outline color

	if(rdPtr->runSurface == NULL)
		return FALSE;

	BOOL Fill = (FColor >= 0);

	//adjust position
	AdjPos(rdPtr,pLeft,pTop);
	AdjCol(FColor);
	AdjCol(OColor);
	AdjThick(Thick,0);

	rdPtr->runSurface->Rectangle(pLeft, pTop, pLeft + pWidth, pTop + pHeight,
		(COLORREF)FColor, Thick, (COLORREF)OColor, Fill);

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actDrawEllipseNew(LPRDATA rdPtr, long param1, long param2)
{
	long pCX = CNC_GetIntParameter(rdPtr);
	long pCY = CNC_GetIntParameter(rdPtr);
	long pWidth = CNC_GetIntParameter(rdPtr);
	long pHeight = CNC_GetIntParameter(rdPtr);
	long FColor = CNC_GetIntParameter(rdPtr);  //fill color (negative = no fill)
	long Thick = CNC_GetIntParameter(rdPtr);
	long OColor = CNC_GetIntParameter(rdPtr);  //outline color

	if(rdPtr->runSurface == NULL)
		return FALSE;

	BOOL Fill = (FColor >= 0);

	//adjust position
	AdjPos(rdPtr,pCX,pCY);
	AdjCol(FColor);
	AdjCol(OColor);
	AdjThick(Thick,0);
	if(Thick == 0)
	{
		OColor = FColor;  //if no thickness, no border
		Thick = 1;
	}

	rdPtr->runSurface->Ellipse(pCX - (pWidth/2), pCY - (pHeight/2), pCX + (pWidth/2),
		pCY + (pHeight/2), (COLORREF)FColor, Thick, (COLORREF)OColor, Fill);

	UpDisp(rdPtr);

	return 0;
}

//draw a polygon from points in a string
short WINAPI DLLExport actDrawPolygonString(LPRDATA rdPtr, long param1, long param2)
{
	char * Str = (char *)CNC_GetParameter(rdPtr);  //string containing points
	long FColor = CNC_GetIntParameter(rdPtr);  //fill color (negative = no fill)
	long Thick = CNC_GetIntParameter(rdPtr);
	long OColor = CNC_GetIntParameter(rdPtr);  //outline color

	if(rdPtr->runSurface == NULL)
		return FALSE;

	BOOL Fill = (FColor >= 0);
	AdjCol(FColor);
	AdjCol(OColor);
	AdjThick(Thick,0);

	long NumPoints = 0;
	POINT * Points = GeneratePointList(rdPtr,Str,NumPoints);

	rdPtr->runSurface->Polygon(Points, NumPoints, FColor, Thick,
		OColor, Fill);

	delete [] Points;

	UpDisp(rdPtr);

	return 0;
}

short WINAPI DLLExport actResize(LPRDATA rdPtr, long Width, long Height)
{
	if(rdPtr->runSurface == NULL)
		return FALSE;

	//if stretching, simply store new height and width in old values
	if(rdPtr->stretching)
	{
		rdPtr->oldwidth = (short)Width;
		rdPtr->oldheight = (short)Height;
		return 0;
	}


	//handle for no stretching	
	LPSURFACE workSurface = rdPtr->runSurface;

	rdPtr->runSurface = new cSurface;
	if (rdPtr->runSurface != NULL)
	{
		rdPtr->swidth = rdPtr->oldwidth = (short)Width;
		rdPtr->sheight = rdPtr->oldheight = (short)Height;
		rdPtr->rHo.hoImgWidth=rdPtr->swidth;
		rdPtr->rHo.hoImgHeight=rdPtr->sheight;
		rdPtr->runSurface->Clone(*workSurface,rdPtr->swidth,rdPtr->sheight);
		workSurface->Stretch(*rdPtr->runSurface,0,0,rdPtr->swidth,
			rdPtr->sheight,BMODE_OPAQUE, BOP_COPY, 0, STRF_COPYALPHA);
	}
	else
	{
		rdPtr->runSurface = workSurface;
		workSurface = NULL;
	}

	if(workSurface != NULL)
	{
		workSurface->Delete();
		delete workSurface;
	}
	UpDisp(rdPtr);
	return 0;
}

//add a point to the current plot
short WINAPI DLLExport actAddPoint(LPRDATA rdPtr, long X, long Y)
{
	POINT * Temp = NULL;

	//increment point count
	rdPtr->NumPoints++;

	//see if we need to increase the array size
	if(rdPtr->NumPoints >= rdPtr->SizePoints)
	{
		Temp = new POINT[rdPtr->SizePoints + POINTS_INTERVAL];
		memcpy(Temp,rdPtr->Points,rdPtr->SizePoints*sizeof(POINT));
		delete [] rdPtr->Points;
		rdPtr->Points = Temp;
		Temp = NULL;
		rdPtr->SizePoints += POINTS_INTERVAL;
	}

	//add the point
	AdjPos(rdPtr,X,Y);
	rdPtr->Points[rdPtr->NumPoints-1].x = X;
	rdPtr->Points[rdPtr->NumPoints-1].y = Y;

	return 0;
}

//Plot polygon
short WINAPI DLLExport actPlotPolygon(LPRDATA rdPtr, long param1, long param2)
{
	long FColor = CNC_GetIntParameter(rdPtr);  //fill color (negative = no fill)
	long Thick = CNC_GetIntParameter(rdPtr);
	long OColor = CNC_GetIntParameter(rdPtr);  //outline color

	if(rdPtr->runSurface == NULL)
		return FALSE;

	BOOL Fill = (FColor >= 0);
	AdjCol(FColor);
	AdjCol(OColor);
	AdjThick(Thick,0);

	//draw it!
	rdPtr->runSurface->Polygon(rdPtr->Points, rdPtr->NumPoints, FColor, Thick,
		OColor, Fill);
	UpDisp(rdPtr);

	//reset counter
	if(rdPtr->RemovePoints)
		rdPtr->NumPoints = 0;

	return 0;
}

//clear points
short WINAPI DLLExport actClearPoints(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->NumPoints = 0;
	rdPtr->SizePoints = POINTS_INTERVAL;
	if(rdPtr->Points != NULL)
		delete [] rdPtr->Points;
	rdPtr->Points = new POINT[rdPtr->SizePoints];
	return 0;
}

//paste object into Overlay
short WINAPI DLLExport actPasteObject(LPRDATA rdPtr, long Obj, long param2)
{
	if (rdPtr->runSurface == NULL)
		return FALSE;

	fprh rhPtr = rdPtr->rHo.hoAdRunHeader;
	cSurface imageSurface;
	LPRO Object = (LPRO)Obj;

	BlitMode bm = (Object->ros.rsEffect & EFFECTFLAG_TRANSPARENT) ? BMODE_TRANSP : BMODE_OPAQUE; 
	BOOL bAntiA = (Object->ros.rsEffect & EFFECTFLAG_ANTIALIAS) ? TRUE : FALSE; 
	BlitOp bo = (BlitOp)(Object->ros.rsEffect & EFFECT_MASK); 
	int effectParam = Object->ros.rsEffectParam; 

	::LockImageSurface (rhPtr->rhIdAppli, Object->roc.rcImage, imageSurface,
		LOCKIMAGE_READBLITONLY);

	imageSurface.Blit(*rdPtr->runSurface, 
		Object->roHo.hoX-rdPtr->X-Object->roHo.hoImgXSpot, 
		Object->roHo.hoY-rdPtr->Y-Object->roHo.hoImgYSpot, 
		bm, bo, (DWORD)effectParam, BLTF_COPYALPHA);

	::UnlockImageSurface (imageSurface);

	UpDisp(rdPtr);

	return 0;
}

//toggle whether or not to keep points
short WINAPI DLLExport actKeepPointsOn(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->RemovePoints = FALSE;
	return 0;
}
short WINAPI DLLExport actKeepPointsOff(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->RemovePoints = TRUE;
	return 0;
}

//set the ink effects!
short WINAPI DLLExport actInkNone(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Effect = BOP_COPY;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actInkSemi(LPRDATA rdPtr, long Param, long param2)
{
	rdPtr->Effect = BOP_BLEND;
	rdPtr->EffectParam = Param;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actInkInvert(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Effect = BOP_INVERT;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actInkXor(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Effect = BOP_XOR;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actInkAnd(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Effect = BOP_AND;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actInkOr(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Effect = BOP_OR;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actInkAndNot(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Effect = BOP_ANDNOT;
	UpDisp(rdPtr);
	return 0;
}

//toggle anti-aliasing
short WINAPI DLLExport actAntiAliasOn(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->AntiA = TRUE;
	UpDisp(rdPtr);
	return 0;
}
short WINAPI DLLExport actAntiAliasOff(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->AntiA = FALSE;
	UpDisp(rdPtr);
	return 0;
}

//set ink effect param
short WINAPI DLLExport actSetInkParam(LPRDATA rdPtr, long Param, long param2)
{
	if(Param < 0)
		Param = 0;
	if(Param > 128)
		Param = 128;
	rdPtr->EffectParam = Param;
	UpDisp(rdPtr);

	return 0;
}

//set auto inking
short WINAPI DLLExport actAutoInking(LPRDATA rdPtr, long param1, long param2)
{
	int Temp = CNC_GetFloatValue(rdPtr, 0);
	rdPtr->FadeSpeed = *((float *)&Temp);
	if(rdPtr->FadeSpeed == 0.0f)
	{
		rdPtr->Fade = FALSE;
		return 0;
	}
	if(!rdPtr->Fade)
	{
		HANDLEFUNCTION(rdPtr);
		rdPtr->Fade = TRUE;
	}
	return 0;
}

//stop auto inking
short WINAPI DLLExport actStopInking(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Fade = FALSE;
	return 0;
}

//reverse auto inking
short WINAPI DLLExport actReverseInking(LPRDATA rdPtr, long param1, long param2)
{
	if(rdPtr->FadeSpeed != 0.0f)
	{
		rdPtr->FadeSpeed *= -1;
		rdPtr->Fade = TRUE;
	}
	return 0;
}

//set ink effect
short WINAPI DLLExport actSetInkEffect(LPRDATA rdPtr, long Effect, long param2)
{
	if((Effect < 0) || (Effect > EFFECT_CODES-2))
		return 0;

	rdPtr->Effect = EffectCodes[Effect];
	UpDisp(rdPtr);

	return 0;
}

//draw a shape from points in a string
short WINAPI DLLExport actDrawShapeString(LPRDATA rdPtr, long param1, long param2)
{
	char * Str = (char *)CNC_GetParameter(rdPtr);  //string containing points
	long FColor = CNC_GetIntParameter(rdPtr);  //fill color (negative = no fill)
	long Thick = CNC_GetIntParameter(rdPtr);
	long OColor = CNC_GetIntParameter(rdPtr);  //outline color

	if(rdPtr->runSurface == NULL)
		return FALSE;

	BOOL Fill = (FColor >= 0);
	AdjCol(FColor);
	AdjCol(OColor);
	AdjThick(Thick,0);

	long NumPoints = 0;
	POINT * Points = GeneratePointList(rdPtr,Str,NumPoints);
	//FastSortPoints(Points, NumPoints);
	SortPoints(Points,NumPoints,Points,NumPoints);

	rdPtr->runSurface->Polygon(Points, NumPoints, FColor, Thick,
		OColor, Fill);

	delete [] Points;

	UpDisp(rdPtr);

	return 0;
}

//Plot shape
short WINAPI DLLExport actPlotShape(LPRDATA rdPtr, long param1, long param2)
{
	long FColor = CNC_GetIntParameter(rdPtr);  //fill color (negative = no fill)
	long Thick = CNC_GetIntParameter(rdPtr);
	long OColor = CNC_GetIntParameter(rdPtr);  //outline color

	if(rdPtr->runSurface == NULL)
		return FALSE;

	BOOL Fill = (FColor >= 0);
	AdjCol(FColor);
	AdjCol(OColor);
	AdjThick(Thick,0);

	POINT * Points = new POINT[rdPtr->NumPoints];
	memcpy(Points,rdPtr->Points,sizeof(POINT)*rdPtr->NumPoints);

	//sort points
	//FastSortPoints(Points, rdPtr->NumPoints);
	SortPoints(Points, rdPtr->NumPoints, Points, rdPtr->NumPoints);

	//draw it!
	rdPtr->runSurface->Polygon(Points, rdPtr->NumPoints, FColor, Thick,
		OColor, Fill);
	UpDisp(rdPtr);

	delete [] Points;

	//reset counter
	if(rdPtr->RemovePoints)
		rdPtr->NumPoints = 0;

	return 0;
}

//paste one overlay region into another Overlay
short WINAPI DLLExport actPasteOverlay(LPRDATA rdPtr, long param1, long param2)
{
	LPRDATA Source = (LPRDATA)CNC_GetIntParameter(rdPtr);
	long SourceX = CNC_GetIntParameter(rdPtr);
	long SourceY = CNC_GetIntParameter(rdPtr);
	long SourceW = CNC_GetIntParameter(rdPtr);
	long SourceH = CNC_GetIntParameter(rdPtr);
	long DestX = CNC_GetIntParameter(rdPtr);
	long DestY = CNC_GetIntParameter(rdPtr);
	long DestW = CNC_GetIntParameter(rdPtr);
	long DestH = CNC_GetIntParameter(rdPtr);
	bool DeleteS = false;
	int Test = 100;

	try
	{
		if((rdPtr->runSurface == NULL) || (Source->runSurface == NULL))
			return FALSE;

		if(rdPtr == Source)
		{
			//we need to make a copy
			Source = new RUNDATA;
			memcpy(Source,rdPtr,sizeof(RUNDATA));
			Source->runSurface = new cSurface;
			Source->runSurface->Create(rdPtr->swidth,rdPtr->sheight,rdPtr->runSurface);
			rdPtr->runSurface->Blit(*Source->runSurface,0,0,BMODE_OPAQUE,BOP_COPY);
			DeleteS = true;
		}

		//adjust positions
		AdjPos(Source,SourceX,SourceY);
		AdjPos(rdPtr,DestX,DestY);

		//verify source rectangle
		if(SourceX < 0)
		{
			SourceW += SourceX;  //adjust width
			SourceX = 0;
		}
		if(SourceY < 0)
		{
			SourceH += SourceY;  //adjust height
			SourceY = 0;
		}
		if(SourceW > Source->swidth - SourceX)
			SourceW = Source->swidth - SourceX;
		if(SourceH > Source->sheight - SourceY)
			SourceH = Source->sheight - SourceY;

		//if all dest params are 0, reshape them
		if(DestW == 0)
			DestW = SourceW;
		if(DestH == 0)
			DestH = SourceH;

		//perform the stretch
		Test = Source->runSurface->Stretch(*rdPtr->runSurface, DestX, DestY, DestW, DestH,
			SourceX, SourceY, SourceW, SourceH, Source->Mode, Source->Effect,
			(DWORD)Source->EffectParam,Source->BlitFlag);
	}
	catch(...)
	{
		//do nothing

	}

	//free memory
	if(DeleteS)
	{
		delete Source->runSurface;
		delete Source;
	}

	UpDisp(rdPtr);

	return 0;
}
short WINAPI DLLExport actDrawString(LPRDATA rdPtr, long param1, long param2)
{
	char* textstr = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));
	int xpos = CNC_GetIntParameter(rdPtr);
	int ypos=CNC_GetIntParameter(rdPtr);
	int wid=CNC_GetIntParameter(rdPtr);
	int hei=CNC_GetIntParameter(rdPtr);
	char*fontface=reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));
	int fontsize=CNC_GetIntParameter(rdPtr);
	long fontcolor=CNC_GetIntParameter(rdPtr);
	RECT mRect;
	mRect.left=xpos;
	mRect.top=ypos;
	mRect.right=mRect.left+wid;
	mRect.bottom=mRect.top+hei;
	LOGFONT			textFont;
	HDC mDC=rdPtr->runSurface->GetDC();
	textFont.lfHeight=-MulDiv(fontsize, GetDeviceCaps(mDC, LOGPIXELSY), 72);
	rdPtr->runSurface->ReleaseDC(mDC);
	textFont.lfWidth=0;
	textFont.lfEscapement=0;
	textFont.lfOrientation=0;
	textFont.lfWeight=FW_NORMAL;
	textFont.lfPitchAndFamily=DEFAULT_PITCH|FF_DONTCARE;
	textFont.lfItalic=false;
	textFont.lfUnderline=false;
	textFont.lfStrikeOut=false;
	textFont.lfCharSet=DEFAULT_CHARSET;
	textFont.lfOutPrecision=OUT_DEFAULT_PRECIS;
	textFont.lfClipPrecision=CLIP_DEFAULT_PRECIS;
	textFont.lfQuality=NONANTIALIASED_QUALITY;
	strcpy((LPSTR)textFont.lfFaceName, fontface);
	HFONT mFont=CreateFontIndirect(&textFont);
	DWORD dwDTFlags = DT_LEFT| DT_TOP | DT_NOPREFIX | DT_WORDBREAK|DT_END_ELLIPSIS;
	rdPtr->runSurface->DrawText(textstr,strlen(textstr),&mRect,dwDTFlags,(COLORREF)fontcolor,mFont);
	UpDisp(rdPtr);
	DeleteObject(mFont);
	return 0;
}
// ============================================================================
//
// EXPRESSIONS ROUTINES
// 
// ============================================================================

// 
long WINAPI DLLExport expGetRed(LPRDATA rdPtr,long param1)
{
	COLORREF	colorRGB;

	long pX = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long pY = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return 0;

	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->GetPixel(pX, pY, colorRGB);
		return GetRValue(colorRGB);
	}

	return 0;
}

long WINAPI DLLExport expGetGreen(LPRDATA rdPtr,long param1)
{
	COLORREF	colorRGB;

	long pX = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long pY = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return 0;

	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->GetPixel(pX, pY, colorRGB);
		return GetGValue(colorRGB);
	}

	return 0;
}

long WINAPI DLLExport expGetBlue(LPRDATA rdPtr,long param1)
{
	COLORREF	colorRGB;

	long pX = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long pY = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return 0;

	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->GetPixel(pX, pY, colorRGB);
		return GetBValue(colorRGB);
	}

	return 0;
}

long WINAPI DLLExport expGetColor(LPRDATA rdPtr,long param1)
{
	COLORREF colorRGB;
	char *	colorReturn = 
		(LPSTR)callRunTimeFunction(rdPtr, RFUNCTION_GETSTRINGSPACE, 15, 0);
	strcpy(colorReturn,"Not Found");

	long pX = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long pY = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	//returning a string
	rdPtr->rHo.hoFlags |= HOF_STRING;

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return (long)colorReturn;

	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->GetPixel(pX, pY, colorRGB);

		if((rdPtr->Mode == BMODE_TRANSP) && (colorRGB == 0))
		{
			//check for transparency
			strcpy(colorReturn,"Transparent");
		}
		else
		{
			BYTE colorRed = GetRValue(colorRGB)>=128?255:0;
			BYTE colorGreen = GetGValue(colorRGB)>=128?255:0;
			BYTE colorBlue = GetBValue(colorRGB)>=128?255:0;

			switch(RGB(colorRed, colorGreen, colorBlue))
			{
			case BLACK:	      strcpy(colorReturn,"Black"); break;
			case RED:		  strcpy(colorReturn,"Red"); break;
			case GREEN:		  strcpy(colorReturn,"Green"); break;
			case BLUE:		  strcpy(colorReturn,"Blue"); break;
			case YELLOW:      strcpy(colorReturn,"Yellow"); break;
			case MAGENTA:     strcpy(colorReturn,"Magenta"); break;
			case CYAN:        strcpy(colorReturn,"Cyan"); break;
			case WHITE:       strcpy(colorReturn,"White"); break;
			}
		}
	}

	return (long)colorReturn;
}

long WINAPI DLLExport expGetRGB(LPRDATA rdPtr,long param1)
{
	COLORREF colorRGB;
	char * colorReturn = 
		(LPSTR)callRunTimeFunction(rdPtr, RFUNCTION_GETSTRINGSPACE, 25, 0);

	strcpy(colorReturn,"Not Found");

	long pX = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long pY = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);

	//returning a string
	rdPtr->rHo.hoFlags |= HOF_STRING;

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return (long)colorReturn;

	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->GetPixel(pX, pY, colorRGB);
		sprintf(colorReturn,"RGB(%d,%d,%d)",GetRValue(colorRGB),GetGValue(colorRGB),GetBValue(colorRGB));
	}

	return (long)colorReturn;
}

long WINAPI DLLExport expGetXPos(LPRDATA rdPtr,long param1)
{
	return rdPtr->X;
}

long WINAPI DLLExport expGetYPos(LPRDATA rdPtr,long param1)
{
	return rdPtr->Y;
}

long WINAPI DLLExport expMakeRange(LPRDATA rdPtr,long param1)
{
	long Color1 = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long Color2 = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);
	long Not = 0;

	//adjust colors
	AdjCol(Color1,Color2,Not);

	if(Color1 >= Color2)
		return MAKELONG(Color1,Color2-Color1);
	//else
	return MAKELONG(Color2,Color1-Color2);
}

long WINAPI DLLExport expNoFillColor(LPRDATA rdPtr,long param1)
{
	return -1;
}

long WINAPI DLLExport expGetWidth(LPRDATA rdPtr,long param1)
{
	return rdPtr->swidth;
}

long WINAPI DLLExport expGetHeight(LPRDATA rdPtr,long param1)
{
	return rdPtr->sheight;
}

long WINAPI DLLExport expGetInkParam(LPRDATA rdPtr,long param1)
{
	return rdPtr->EffectParam;
}

long WINAPI DLLExport expGetInkSpeed(LPRDATA rdPtr,long param1)
{
	long Temp = *(long *)&rdPtr->FadeSpeed;
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	return Temp;
}

long WINAPI DLLExport expGetInkEffect(LPRDATA rdPtr,long param1)
{
	for(int i = 0; EffectCodes[i] != BOP_MAX; i++)
	{
		if(EffectCodes[i] == rdPtr->Effect)
			return i;
	}
	return -1;
}

long WINAPI DLLExport expGetFixedValue(LPRDATA rdPtr,long param1)
{
	return (long)rdPtr;
}

long WINAPI DLLExport expGetCIndex(LPRDATA rdPtr,long param1)
{
	COLORREF	colorRGB;

	long pX = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long pY = CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);

	//adjust position
	AdjPos(rdPtr,pX,pY);

	if((pX < 0) || (pY < 0) || (pX > rdPtr->swidth) || (pY > rdPtr->sheight))
		return 0;

	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->GetPixel(pX, pY, colorRGB);
		return colorRGB;
	}

	return 0;
}

// ============================================================================
//
// MATT'S ROUTINES
// 
// ============================================================================

//you need to delete the list returned!
POINT * GeneratePointList(LPRDATA rdPtr, char * Str, long & NumPoints)
{
	//prepare to parse list by declaring starting variables
	long Length = strlen(Str);
	long Start = 0,
		CurrentPoint = 0,
		Context = 0;  //0=find '(', 1=find ',', 2=find ')'

	NumPoints = NumChar(Str,'(',Length);
	POINT * Points = new POINT[NumPoints];
	//make all points 0 in case string is improper
	memset(Points,0,sizeof(POINT)*NumPoints);
	for(int i = 0; (i < Length) && (CurrentPoint < NumPoints); i++)
	{
		//using context to do this.  There are only three possibilities
		switch(Context)
		{
		case 0:
			if(Str[i] == '(')
			{
				Start = i+1;
				Context = 1;
			}
			break;

		case 1:
			if(Str[i] == ',')
			{
				Str[i] = '\0';
				Points[CurrentPoint].x = atol(Str+Start);
				Str[i] = ',';
				Start = i+1;
				Context = 2;
			}
			break;

		case 2:
			if(Str[i] == ')')
			{
				Str[i] = '\0';
				Points[CurrentPoint].y = atol(Str+Start);
				Str[i] = ')';
				//adjust position
				AdjPos(rdPtr,Points[CurrentPoint].x,Points[CurrentPoint].y);
				CurrentPoint++;
				Context = 0;
			}
			break;
		}
	}
	return Points;
}

void FastSortPoints(POINT * Points, long NumPoints)
{
	long CurPoint,i,j,
		NumLessOne = NumPoints-1;
	double CurDist,TempDist;
	bool Fresh;

	for(i=0; i < NumLessOne; i++)
	{
		CurPoint = -1;
		Fresh = true;
		for(j=i+1; j < NumPoints; j++)
		{
			TempDist = double(Points[i].x-Points[j].x)*double(Points[i].x-Points[j].x)+
				double(Points[i].y-Points[j].y)*double(Points[i].y-Points[j].y);

			//see if new point is closer
			if((TempDist < CurDist) || Fresh)
			{
				CurPoint = j;
				CurDist = TempDist;
			}
		}

		//swap points
		if(CurPoint != -1)
			Swap(Points[i+1],Points[j]);
	}

	return;
}

//sort the point to create a true polygon
//  this is recursive
//  returns true when a valid order has been found
bool SortPoints(POINT * Points, long NumPoints, POINT * Original, long OrgPoints)
{
	long i;

	//if greater than 1, use a loop to whittle down to 1
	if(NumPoints > 1)
	{
		for(i=0; i < NumPoints; i++)
		{
			//swap new point as head
			Swap(Points[0],Points[i]);
			if(SortPoints(Points+1,NumPoints-1,Original,OrgPoints))
				return true;
			//else
			//swap back to maintain original order
			Swap(Points[0],Points[i]);
		}
		return false;
	}
	//else
	return TestPoints(Original,OrgPoints);
}

//returns  true if no points intersect
bool TestPoints(POINT * Points, long NumPoints)
{
	//variables
	long i,j,Limit;
	Limit = NumPoints - 2;
	for(i=0; i < Limit; i++)
	{
		for(j=(i+2); j < NumPoints; j++)
		{
			if(SegmentsIntersect(Points[i],Points[(i+1)%NumPoints],
				Points[j%NumPoints],Points[(j+1)%NumPoints]))
			{
				return false;
			}
		}
	}
	//none intersect!
	return true;
}

//returns true if the two segments intersect
bool SegmentsIntersect(POINT P11, POINT P12, POINT P21, POINT P22)
{
	//varaibles
	long DeltaX1 = P11.x - P12.x,
		DeltaX2 =  P21.x - P22.x;
	double M1,M2,XI,YI,DeltaM;

	//find intersection of LINES
	if((DeltaX1 == 0) || (DeltaX2 == 0))
	{
		//at least one line is vertical
		if((DeltaX1 == 0) && (DeltaX2 == 0))  //lines are parallel and never intersect
			return false;

		//when Line1 is vertical
		if(DeltaX1 == 0)
		{
			XI = P11.x;
			YI = (double(P21.y - P22.y)/DeltaX2) * (XI - P21.x) + P21.y;
		}
		else
		{
			XI = P21.x;
			YI = (double(P11.y - P12.y)/DeltaX1) * (XI - P11.x) + P11.y;
		}
	}
	else
	{
		M1 = double(P11.y - P12.y)/DeltaX1;
		M2 = double(P21.y - P22.y)/DeltaX2;
		DeltaM = M1 - M2;
		if(DeltaM == 0.0)  //lines are parallel and never intersect
			return false;

		//find XI and YI
		XI = (M1*P11.x - P11.y + P21.y - M2*P21.x)/DeltaM;
		YI = M1*(XI - P11.x) + P11.y;
	}

	//see if the intersection is within range
	return (InRange(XI,double(P11.x),double(P12.x)) &&
		InRange(XI,double(P21.x),double(P22.x)) &&
		InRange(YI,double(P11.y),double(P12.y)) &&
		InRange(YI,double(P21.y),double(P22.y)));
}

//stretch object to fit frame
void StretchObject(LPRDATA rdPtr)
{
	LPSURFACE workSurface = NULL;
	LPSURFACE pProto = NULL;

	workSurface = new cSurface;

	if ( GetSurfacePrototype(&pProto, rdPtr->runSurface->GetDepth(), ST_MEMORYWITHPERMANENTDC, SD_DIB) )
	{
		fprh	rhPtr = rdPtr->rHo.hoAdRunHeader;
		//fpry    ryPtr = (fpry)((fpchar)rhPtr + rhPtr->rhyOffset);

		workSurface->Clone(*rdPtr->runSurface, rdPtr->runSurface->GetWidth(),
			rdPtr->runSurface->GetHeight());
		if(rdPtr->runSurface->Blit(*workSurface))
		{
			rdPtr->oldwidth = rdPtr->swidth;
			rdPtr->oldheight = rdPtr->sheight;
			rdPtr->OldX = rdPtr->X;
			rdPtr->OldY = rdPtr->Y;
		}
		rdPtr->runSurface->Delete();
		delete rdPtr->runSurface;

		rdPtr->runSurface = new cSurface;
		if (rdPtr->runSurface != NULL)
		{
			rdPtr->swidth = rhPtr->rhLevelSx;
			rdPtr->sheight = rhPtr->rhLevelSy;
			rdPtr->X = 0;
			rdPtr->Y = 0;
			rdPtr->rHo.hoX=rdPtr->X;
			rdPtr->rHo.hoY=rdPtr->Y;
			rdPtr->rHo.hoImgWidth=rdPtr->swidth;
			rdPtr->rHo.hoImgHeight=rdPtr->sheight;
			rdPtr->runSurface->Create(rdPtr->swidth,rdPtr->sheight,pProto);
			workSurface->Stretch(*rdPtr->runSurface,STRF_COPYALPHA);
		}
	}

	workSurface->Delete();
	delete workSurface;
}

//Inline functions
//set the display to be updated or update immediately
inline void UpDisp(LPRDATA rdPtr)
{
	if(rdPtr->debugmode && rdPtr->Immediate)
	{
		callRunTimeFunction(rdPtr, RFUNCTION_REDISPLAY, 0, 0);
	}
	else
	{
#pragma message("Does this cause refresh when not in debug mode?")
		if(rdPtr->Automatic)
			callRunTimeFunction(rdPtr, RFUNCTION_REDRAW, 0, 0);
	}

	return;
}
//adjust color codes in some way
inline void AdjCol(long & pR, long & pG, long & pB)
{
	if(pR < 0)
		pR = 0;
	if(pR > 255)
		pR = 255;
	if(pG < 0)
		pG = 0;
	if(pG > 255)
		pG = 255;
	if(pB < 0)
		pB = 0;
	if(pB > 255)
		pB = 255;
	return;
}
//adjust color codes in some way
inline void AdjCol(long & Color)
{
	if(Color < 0)
		Color = 0;
	if(Color > 16777215)
		Color = 16777215;
	return;
}
//adjust thickness
inline void AdjThick(long & Thick, long Low)
{
	if(Thick < Low)
		Thick = Low;
	return;
}
//adjust position if using actual positions
inline void AdjPos(LPRDATA rdPtr, long & X, long & Y)
{
	if(rdPtr->AbsolutePos)
	{
		X -= rdPtr->X;
		Y -= rdPtr->Y;
	}
	return;
}
//compares ranges (bounds are inclusive!)
template<typename T>
inline bool InRange(T Check, T LowBound, T UpBound)
{
	return ((Check >= LowBound) && (Check <= UpBound)) || 
		((Check <= LowBound) && (Check >= UpBound));
}
//swap two values
template<typename T>
void Swap(T & One, T & Two)
{
	T Temp = One;
	One = Two;
	Two = Temp;
}
//Sets a flag
void SetFlag(UINT & Source, UINT Flag, bool On)
{
	if(On)
		Source |= Flag;
	else
		Source &= ~Flag;
}
//returns # occurenses of a char in a string
long NumChar(char * Str, char Thing, long Length)
{
	long Out = 0;
	for(int i = 0; i < Length; i++)
	{
		if(Str[i] == Thing)
			Out++;
	}
	return Out;
}

// ----------------------------------------------------------
// Condition / Action / Expression jump table
// ----------------------------------------------------------
// Contains the address inside the extension of the different
// routines that handle the action, conditions and expressions.
// Located at the end of the source for convinience
// Must finish with a 0
//
long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) = 
{ 
	cndMatchColor,
		cndMatchColorRGB,
		cndIsOutside,
		cndIsDebugOn,
		cndCompareRGB,
		cndAlwaysTrue,
		cndIsFading,
		0
};

short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
{
	actTurnDebugOn,
		actTurnDebugOff,
		actClearOverlay,
		actReplaceColor,
		actSetPixel,
		actDrawLine,
		actDrawRectangle,
		actDrawEllipse,
		actClearOverlayRGB,
		actReplaceColorRGB,
		actSetPixelRGB,  //10
		actDrawLineRGB,
		actDrawRectangleRGB,
		actDrawEllipseRGB,
		actLoadImage,
		actTurnStretchingOn,
		actTurnStretchingOff,
		actFloodFill,
		actFloodFillRGB,
		actSaveImage,
		actSetPosition,  //20
		actSetXPosition,
		actSetYPosition,
		actAutoOn,
		actAutoOff,
		actImmediateOn,
		actImmediateOff,
		actAbsoluteOn,
		actAbsoluteOff,
		actModeOpaque,
		actModeTransp,  //30
		actUpdateDisplay,
		actClearOverlayNew,
		actReplaceColorNew,
		actSetPixelNew,
		actDrawLineNew,
		actDrawRectangleNew,
		actDrawEllipseNew,
		actFloodFillNew,
		actDrawPolygonString,
		actResize,  //40
		actAddPoint,
		actPlotPolygon,
		actClearPoints,
		actPasteObject,
		actKeepPointsOn,
		actKeepPointsOff,
		actInkNone,
		actInkSemi,
		actInkInvert,
		actInkXor,  //50
		actInkAnd,
		actInkOr,
		actInkAndNot,
		actAntiAliasOn,
		actAntiAliasOff,
		actSetInkParam,
		actAutoInking,
		actStopInking,
		actReverseInking,
		actSetInkEffect,  //60
		actDrawShapeString,
		actPlotShape,
		actPasteOverlay,
		actDrawString,
		0
};

long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) = 
{     
	expGetRed,
		expGetGreen,
		expGetBlue,
		expGetColor,
		expGetRGB,
		expGetXPos,
		expGetYPos,
		expMakeRange,
		expNoFillColor,
		expGetWidth,
		expGetHeight,
		expGetInkParam,
		expGetInkSpeed,
		expGetInkEffect,
		expGetFixedValue,
		expGetCIndex,
		0
};
